package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriberSpecBuilder extends SubscriberSpecFluentImpl<SubscriberSpecBuilder> implements VisitableBuilder<SubscriberSpec,SubscriberSpecBuilder>{
  public SubscriberSpecBuilder() {
    this(false);
  }
  public SubscriberSpecBuilder(Boolean validationEnabled) {
    this(new SubscriberSpec(), validationEnabled);
  }
  public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriberSpec(), validationEnabled);
  }
  public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,SubscriberSpec instance) {
    this(fluent, instance, false);
  }
  public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,SubscriberSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDelivery(instance.getDelivery());
      fluent.withGeneration(instance.getGeneration());
      fluent.withReplyUri(instance.getReplyUri());
      fluent.withSubscriberUri(instance.getSubscriberUri());
      fluent.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriberSpecBuilder(SubscriberSpec instance) {
    this(instance,false);
  }
  public SubscriberSpecBuilder(SubscriberSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDelivery(instance.getDelivery());
      this.withGeneration(instance.getGeneration());
      this.withReplyUri(instance.getReplyUri());
      this.withSubscriberUri(instance.getSubscriberUri());
      this.withUid(instance.getUid());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriberSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriberSpec build() {
    SubscriberSpec buildable = new SubscriberSpec(fluent.getDelivery(),fluent.getGeneration(),fluent.getReplyUri(),fluent.getSubscriberUri(),fluent.getUid());
    return buildable;
  }
  
}