package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CloudEventAttributesBuilder extends CloudEventAttributesFluentImpl<CloudEventAttributesBuilder> implements VisitableBuilder<CloudEventAttributes,CloudEventAttributesBuilder>{
  public CloudEventAttributesBuilder() {
    this(false);
  }
  public CloudEventAttributesBuilder(Boolean validationEnabled) {
    this(new CloudEventAttributes(), validationEnabled);
  }
  public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent) {
    this(fluent, false);
  }
  public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CloudEventAttributes(), validationEnabled);
  }
  public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,CloudEventAttributes instance) {
    this(fluent, instance, false);
  }
  public CloudEventAttributesBuilder(CloudEventAttributesFluent<?> fluent,CloudEventAttributes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSource(instance.getSource());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CloudEventAttributesBuilder(CloudEventAttributes instance) {
    this(instance,false);
  }
  public CloudEventAttributesBuilder(CloudEventAttributes instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSource(instance.getSource());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  CloudEventAttributesFluent<?> fluent;
  Boolean validationEnabled;
  public CloudEventAttributes build() {
    CloudEventAttributes buildable = new CloudEventAttributes(fluent.getSource(),fluent.getType());
    return buildable;
  }
  
}