package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelSpecBuilder extends ChannelSpecFluentImpl<ChannelSpecBuilder> implements VisitableBuilder<ChannelSpec,ChannelSpecBuilder>{
  public ChannelSpecBuilder() {
    this(false);
  }
  public ChannelSpecBuilder(Boolean validationEnabled) {
    this(new ChannelSpec(), validationEnabled);
  }
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelSpec(), validationEnabled);
  }
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance) {
    this(fluent, instance, false);
  }
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChannelTemplate(instance.getChannelTemplate());
      fluent.withDelivery(instance.getDelivery());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelSpecBuilder(ChannelSpec instance) {
    this(instance,false);
  }
  public ChannelSpecBuilder(ChannelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChannelTemplate(instance.getChannelTemplate());
      this.withDelivery(instance.getDelivery());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelSpec build() {
    ChannelSpec buildable = new ChannelSpec(fluent.getChannelTemplate(),fluent.getDelivery(),fluent.getSubscribers());
    return buildable;
  }
  
}