package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelStatusBuilder extends ChannelStatusFluentImpl<ChannelStatusBuilder> implements VisitableBuilder<ChannelStatus,ChannelStatusBuilder>{
  public ChannelStatusBuilder() {
    this(false);
  }
  public ChannelStatusBuilder(Boolean validationEnabled) {
    this(new ChannelStatus(), validationEnabled);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelStatus(), validationEnabled);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance) {
    this(fluent, instance, false);
  }
  public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChannel(instance.getChannel());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterChannel(instance.getDeadLetterChannel());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelStatusBuilder(ChannelStatus instance) {
    this(instance,false);
  }
  public ChannelStatusBuilder(ChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withChannel(instance.getChannel());
      this.withConditions(instance.getConditions());
      this.withDeadLetterChannel(instance.getDeadLetterChannel());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelStatus build() {
    ChannelStatus buildable = new ChannelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getChannel(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.getSubscribers());
    return buildable;
  }
  
}