package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelTemplateSpecBuilder extends ChannelTemplateSpecFluentImpl<ChannelTemplateSpecBuilder> implements VisitableBuilder<ChannelTemplateSpec,ChannelTemplateSpecBuilder>{
  public ChannelTemplateSpecBuilder() {
    this(false);
  }
  public ChannelTemplateSpecBuilder(Boolean validationEnabled) {
    this(new ChannelTemplateSpec(), validationEnabled);
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ChannelTemplateSpec(), validationEnabled);
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,ChannelTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,ChannelTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpec instance) {
    this(instance,false);
  }
  public ChannelTemplateSpecBuilder(ChannelTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChannelTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ChannelTemplateSpec build() {
    ChannelTemplateSpec buildable = new ChannelTemplateSpec(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec());
    return buildable;
  }
  
}