package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InMemoryChannelSpecBuilder extends InMemoryChannelSpecFluentImpl<InMemoryChannelSpecBuilder> implements VisitableBuilder<InMemoryChannelSpec,InMemoryChannelSpecBuilder>{
  public InMemoryChannelSpecBuilder() {
    this(false);
  }
  public InMemoryChannelSpecBuilder(Boolean validationEnabled) {
    this(new InMemoryChannelSpec(), validationEnabled);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InMemoryChannelSpec(), validationEnabled);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance) {
    this(fluent, instance, false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDelivery(instance.getDelivery());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance) {
    this(instance,false);
  }
  public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDelivery(instance.getDelivery());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  InMemoryChannelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public InMemoryChannelSpec build() {
    InMemoryChannelSpec buildable = new InMemoryChannelSpec(fluent.getDelivery(),fluent.getSubscribers());
    return buildable;
  }
  
}