package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InMemoryChannelSpecFluentImpl<A extends InMemoryChannelSpecFluent<A>> extends BaseFluent<A> implements InMemoryChannelSpecFluent<A>{
  public InMemoryChannelSpecFluentImpl() {
  }
  public InMemoryChannelSpecFluentImpl(InMemoryChannelSpec instance) {
    if (instance != null) {
      this.withDelivery(instance.getDelivery());
      this.withSubscribers(instance.getSubscribers());
    }
  }
  private DeliverySpecBuilder delivery;
  private ArrayList<SubscriberSpecBuilder> subscribers = new ArrayList<SubscriberSpecBuilder>();
  
  /**
   * This method has been deprecated, please use method buildDelivery instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeliverySpec getDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public Boolean hasDelivery() {
    return this.delivery != null;
  }
  public InMemoryChannelSpecFluentImpl.DeliveryNested<A> withNewDelivery() {
    return new InMemoryChannelSpecFluentImpl.DeliveryNestedImpl();
  }
  public InMemoryChannelSpecFluentImpl.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new InMemoryChannelSpecFluentImpl.DeliveryNestedImpl(item);
  }
  public InMemoryChannelSpecFluentImpl.DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(getDelivery());
  }
  public InMemoryChannelSpecFluentImpl.DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
  }
  public InMemoryChannelSpecFluentImpl.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
  }
  public A addToSubscribers(int index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").add(index, builder); subscribers.add(index, builder);}
    return (A)this;
  }
  public A setToSubscribers(int index,SubscriberSpec item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").set(index, builder); subscribers.set(index, builder);}
    return (A)this;
  }
  public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A addAllToSubscribers(Collection<SubscriberSpec> items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... items) {
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
    for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
    if (subscribers == null) return (A) this;
    final Iterator<SubscriberSpecBuilder> each = subscribers.iterator();
    final List visitables = _visitables.get("subscribers");
    while (each.hasNext()) {
      SubscriberSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubscribers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriberSpec> getSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public List<SubscriberSpec> buildSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public SubscriberSpec buildSubscriber(int index) {
    return this.subscribers.get(index).build();
  }
  public SubscriberSpec buildFirstSubscriber() {
    return this.subscribers.get(0).build();
  }
  public SubscriberSpec buildLastSubscriber() {
    return this.subscribers.get(subscribers.size() - 1).build();
  }
  public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    for (SubscriberSpecBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubscribers(List<SubscriberSpec> subscribers) {
    if (this.subscribers != null) { _visitables.get("subscribers").clear();}
    if (subscribers != null) {this.subscribers = new ArrayList(); for (SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
  }
  public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec... subscribers) {
    if (this.subscribers != null) {this.subscribers.clear(); _visitables.remove("subscribers"); }
    if (subscribers != null) {for (SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
  }
  public Boolean hasSubscribers() {
    return subscribers != null && !subscribers.isEmpty();
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> addNewSubscriber() {
    return new InMemoryChannelSpecFluentImpl.SubscribersNestedImpl();
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
    return new InMemoryChannelSpecFluentImpl.SubscribersNestedImpl(-1, item);
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberSpec item) {
    return new InMemoryChannelSpecFluentImpl.SubscribersNestedImpl(index, item);
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> editSubscriber(int index) {
    if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> editFirstSubscriber() {
    if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
    return setNewSubscriberLike(0, buildSubscriber(0));
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> editLastSubscriber() {
    int index = subscribers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelSpecFluentImpl.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscribers.size();i++) { 
    if (predicate.test(subscribers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InMemoryChannelSpecFluentImpl that = (InMemoryChannelSpecFluentImpl) o;
    if (!java.util.Objects.equals(delivery, that.delivery)) return false;

    if (!java.util.Objects.equals(subscribers, that.subscribers)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(delivery,  subscribers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (subscribers != null) { sb.append("subscribers:"); sb.append(subscribers); }
    sb.append("}");
    return sb.toString();
  }
  class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<InMemoryChannelSpecFluentImpl.DeliveryNested<N>> implements InMemoryChannelSpecFluentImpl.DeliveryNested<N>,Nested<N>{
    DeliveryNestedImpl(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliveryNestedImpl() {
      this.builder = new DeliverySpecBuilder(this);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) InMemoryChannelSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  class SubscribersNestedImpl<N> extends SubscriberSpecFluentImpl<InMemoryChannelSpecFluentImpl.SubscribersNested<N>> implements InMemoryChannelSpecFluentImpl.SubscribersNested<N>,Nested<N>{
    SubscribersNestedImpl(int index,SubscriberSpec item) {
      this.index = index;
      this.builder = new SubscriberSpecBuilder(this, item);
    }
    SubscribersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriberSpecBuilder(this);
    }
    SubscriberSpecBuilder builder;
    int index;
    public N and() {
      return (N) InMemoryChannelSpecFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}