package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl;
import java.lang.Deprecated;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InMemoryChannelStatusFluentImpl<A extends InMemoryChannelStatusFluent<A>> extends BaseFluent<A> implements InMemoryChannelStatusFluent<A>{
  public InMemoryChannelStatusFluentImpl() {
  }
  public InMemoryChannelStatusFluentImpl(InMemoryChannelStatus instance) {
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterChannel(instance.getDeadLetterChannel());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
    }
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private KReferenceBuilder deadLetterChannel;
  private String deadLetterSinkUri;
  private Long observedGeneration;
  private ArrayList<SubscriberStatusBuilder> subscribers = new ArrayList<SubscriberStatusBuilder>();
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewAddress(String url) {
    return (A)withAddress(new Addressable(url));
  }
  public InMemoryChannelStatusFluentImpl.AddressNested<A> withNewAddress() {
    return new InMemoryChannelStatusFluentImpl.AddressNestedImpl();
  }
  public InMemoryChannelStatusFluentImpl.AddressNested<A> withNewAddressLike(Addressable item) {
    return new InMemoryChannelStatusFluentImpl.AddressNestedImpl(item);
  }
  public InMemoryChannelStatusFluentImpl.AddressNested<A> editAddress() {
    return withNewAddressLike(getAddress());
  }
  public InMemoryChannelStatusFluentImpl.AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public InMemoryChannelStatusFluentImpl.AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl();
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InMemoryChannelStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDeadLetterChannel instead.
   * @return The buildable object.
   */
  @Deprecated
  public KReference getDeadLetterChannel() {
    return this.deadLetterChannel!=null ?this.deadLetterChannel.build():null;
  }
  public KReference buildDeadLetterChannel() {
    return this.deadLetterChannel!=null ?this.deadLetterChannel.build():null;
  }
  public A withDeadLetterChannel(KReference deadLetterChannel) {
    _visitables.get("deadLetterChannel").remove(this.deadLetterChannel);
    if (deadLetterChannel!=null){ this.deadLetterChannel= new KReferenceBuilder(deadLetterChannel); _visitables.get("deadLetterChannel").add(this.deadLetterChannel);} else { this.deadLetterChannel = null; _visitables.get("deadLetterChannel").remove(this.deadLetterChannel); } return (A) this;
  }
  public Boolean hasDeadLetterChannel() {
    return this.deadLetterChannel != null;
  }
  public A withNewDeadLetterChannel(String apiVersion,String group,String kind,String name,String namespace) {
    return (A)withDeadLetterChannel(new KReference(apiVersion, group, kind, name, namespace));
  }
  public InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<A> withNewDeadLetterChannel() {
    return new InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl();
  }
  public InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(KReference item) {
    return new InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl(item);
  }
  public InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<A> editDeadLetterChannel() {
    return withNewDeadLetterChannelLike(getDeadLetterChannel());
  }
  public InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<A> editOrNewDeadLetterChannel() {
    return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): new KReferenceBuilder().build());
  }
  public InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(KReference item) {
    return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): item);
  }
  public String getDeadLetterSinkUri() {
    return this.deadLetterSinkUri;
  }
  public A withDeadLetterSinkUri(String deadLetterSinkUri) {
    this.deadLetterSinkUri=deadLetterSinkUri; return (A) this;
  }
  public Boolean hasDeadLetterSinkUri() {
    return this.deadLetterSinkUri != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToSubscribers(int index,SubscriberStatus item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").add(index, builder); subscribers.add(index, builder);}
    return (A)this;
  }
  public A setToSubscribers(int index,SubscriberStatus item) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
    if (index < 0 || index >= subscribers.size()) { _visitables.get("subscribers").add(builder); subscribers.add(builder); } else { _visitables.get("subscribers").set(index, builder); subscribers.set(index, builder);}
    return (A)this;
  }
  public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A addAllToSubscribers(Collection<SubscriberStatus> items) {
    if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
  }
  public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubscribers(Collection<SubscriberStatus> items) {
    for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubscribers(Predicate<SubscriberStatusBuilder> predicate) {
    if (subscribers == null) return (A) this;
    final Iterator<SubscriberStatusBuilder> each = subscribers.iterator();
    final List visitables = _visitables.get("subscribers");
    while (each.hasNext()) {
      SubscriberStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubscribers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriberStatus> getSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public List<SubscriberStatus> buildSubscribers() {
    return subscribers != null ? build(subscribers) : null;
  }
  public SubscriberStatus buildSubscriber(int index) {
    return this.subscribers.get(index).build();
  }
  public SubscriberStatus buildFirstSubscriber() {
    return this.subscribers.get(0).build();
  }
  public SubscriberStatus buildLastSubscriber() {
    return this.subscribers.get(subscribers.size() - 1).build();
  }
  public SubscriberStatus buildMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubscribers(List<SubscriberStatus> subscribers) {
    if (this.subscribers != null) { _visitables.get("subscribers").clear();}
    if (subscribers != null) {this.subscribers = new ArrayList(); for (SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
  }
  public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... subscribers) {
    if (this.subscribers != null) {this.subscribers.clear(); _visitables.remove("subscribers"); }
    if (subscribers != null) {for (SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
  }
  public Boolean hasSubscribers() {
    return subscribers != null && !subscribers.isEmpty();
  }
  public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid) {
    return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> addNewSubscriber() {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl();
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item) {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(-1, item);
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberStatus item) {
    return new InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(index, item);
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> editSubscriber(int index) {
    if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> editFirstSubscriber() {
    if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
    return setNewSubscriberLike(0, buildSubscriber(0));
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> editLastSubscriber() {
    int index = subscribers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public InMemoryChannelStatusFluentImpl.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subscribers.size();i++) { 
    if (predicate.test(subscribers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
    return setNewSubscriberLike(index, buildSubscriber(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InMemoryChannelStatusFluentImpl that = (InMemoryChannelStatusFluentImpl) o;
    if (!java.util.Objects.equals(address, that.address)) return false;

    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(deadLetterChannel, that.deadLetterChannel)) return false;

    if (!java.util.Objects.equals(deadLetterSinkUri, that.deadLetterSinkUri)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(subscribers, that.subscribers)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  conditions,  deadLetterChannel,  deadLetterSinkUri,  observedGeneration,  subscribers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (deadLetterChannel != null) { sb.append("deadLetterChannel:"); sb.append(deadLetterChannel + ","); }
    if (deadLetterSinkUri != null) { sb.append("deadLetterSinkUri:"); sb.append(deadLetterSinkUri + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (subscribers != null) { sb.append("subscribers:"); sb.append(subscribers); }
    sb.append("}");
    return sb.toString();
  }
  class AddressNestedImpl<N> extends AddressableFluentImpl<InMemoryChannelStatusFluentImpl.AddressNested<N>> implements InMemoryChannelStatusFluentImpl.AddressNested<N>,Nested<N>{
    AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<InMemoryChannelStatusFluentImpl.ConditionsNested<N>> implements InMemoryChannelStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    int index;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class DeadLetterChannelNestedImpl<N> extends KReferenceFluentImpl<InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<N>> implements InMemoryChannelStatusFluentImpl.DeadLetterChannelNested<N>,Nested<N>{
    DeadLetterChannelNestedImpl(KReference item) {
      this.builder = new KReferenceBuilder(this, item);
    }
    DeadLetterChannelNestedImpl() {
      this.builder = new KReferenceBuilder(this);
    }
    KReferenceBuilder builder;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.withDeadLetterChannel(builder.build());
    }
    public N endDeadLetterChannel() {
      return and();
    }
    
  }
  class SubscribersNestedImpl<N> extends SubscriberStatusFluentImpl<InMemoryChannelStatusFluentImpl.SubscribersNested<N>> implements InMemoryChannelStatusFluentImpl.SubscribersNested<N>,Nested<N>{
    SubscribersNestedImpl(int index,SubscriberStatus item) {
      this.index = index;
      this.builder = new SubscriberStatusBuilder(this, item);
    }
    SubscribersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriberStatusBuilder(this);
    }
    SubscriberStatusBuilder builder;
    int index;
    public N and() {
      return (N) InMemoryChannelStatusFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}