package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionBuilder extends SubscriptionFluentImpl<SubscriptionBuilder> implements VisitableBuilder<Subscription,SubscriptionBuilder>{
  public SubscriptionBuilder() {
    this(false);
  }
  public SubscriptionBuilder(Boolean validationEnabled) {
    this(new Subscription(), validationEnabled);
  }
  public SubscriptionBuilder(SubscriptionFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionBuilder(SubscriptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Subscription(), validationEnabled);
  }
  public SubscriptionBuilder(SubscriptionFluent<?> fluent,Subscription instance) {
    this(fluent, instance, false);
  }
  public SubscriptionBuilder(SubscriptionFluent<?> fluent,Subscription instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionBuilder(Subscription instance) {
    this(instance,false);
  }
  public SubscriptionBuilder(Subscription instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionFluent<?> fluent;
  Boolean validationEnabled;
  public Subscription build() {
    Subscription buildable = new Subscription(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}