package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionSpecBuilder extends SubscriptionSpecFluentImpl<SubscriptionSpecBuilder> implements VisitableBuilder<SubscriptionSpec,SubscriptionSpecBuilder>{
  public SubscriptionSpecBuilder() {
    this(false);
  }
  public SubscriptionSpecBuilder(Boolean validationEnabled) {
    this(new SubscriptionSpec(), validationEnabled);
  }
  public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionSpec(), validationEnabled);
  }
  public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,SubscriptionSpec instance) {
    this(fluent, instance, false);
  }
  public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,SubscriptionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChannel(instance.getChannel());
      fluent.withDelivery(instance.getDelivery());
      fluent.withReply(instance.getReply());
      fluent.withSubscriber(instance.getSubscriber());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionSpecBuilder(SubscriptionSpec instance) {
    this(instance,false);
  }
  public SubscriptionSpecBuilder(SubscriptionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChannel(instance.getChannel());
      this.withDelivery(instance.getDelivery());
      this.withReply(instance.getReply());
      this.withSubscriber(instance.getSubscriber());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionSpec build() {
    SubscriptionSpec buildable = new SubscriptionSpec(fluent.getChannel(),fluent.getDelivery(),fluent.getReply(),fluent.getSubscriber());
    return buildable;
  }
  
}