package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionStatusBuilder extends SubscriptionStatusFluentImpl<SubscriptionStatusBuilder> implements VisitableBuilder<SubscriptionStatus,SubscriptionStatusBuilder>{
  public SubscriptionStatusBuilder() {
    this(false);
  }
  public SubscriptionStatusBuilder(Boolean validationEnabled) {
    this(new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPhysicalSubscription(instance.getPhysicalSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance) {
    this(instance,false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPhysicalSubscription(instance.getPhysicalSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionStatus build() {
    SubscriptionStatus buildable = new SubscriptionStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getPhysicalSubscription());
    return buildable;
  }
  
}