package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigurationStatusBuilder extends ConfigurationStatusFluentImpl<ConfigurationStatusBuilder> implements VisitableBuilder<ConfigurationStatus,ConfigurationStatusBuilder>{
  public ConfigurationStatusBuilder() {
    this(false);
  }
  public ConfigurationStatusBuilder(Boolean validationEnabled) {
    this(new ConfigurationStatus(), validationEnabled);
  }
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigurationStatus(), validationEnabled);
  }
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,ConfigurationStatus instance) {
    this(fluent, instance, false);
  }
  public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,ConfigurationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
      fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigurationStatusBuilder(ConfigurationStatus instance) {
    this(instance,false);
  }
  public ConfigurationStatusBuilder(ConfigurationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
      this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigurationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigurationStatus build() {
    ConfigurationStatus buildable = new ConfigurationStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration());
    return buildable;
  }
  
}