package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerStatusBuilder extends ContainerStatusFluentImpl<ContainerStatusBuilder> implements VisitableBuilder<ContainerStatus,ContainerStatusBuilder>{
  public ContainerStatusBuilder() {
    this(false);
  }
  public ContainerStatusBuilder(Boolean validationEnabled) {
    this(new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,ContainerStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerStatusBuilder(ContainerStatusFluent<?> fluent,ContainerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withImageDigest(instance.getImageDigest());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerStatusBuilder(ContainerStatus instance) {
    this(instance,false);
  }
  public ContainerStatusBuilder(ContainerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withImageDigest(instance.getImageDigest());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerStatus build() {
    ContainerStatus buildable = new ContainerStatus(fluent.getImageDigest(),fluent.getName());
    return buildable;
  }
  
}