package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RevisionBuilder extends RevisionFluentImpl<RevisionBuilder> implements VisitableBuilder<Revision,RevisionBuilder>{
  public RevisionBuilder() {
    this(false);
  }
  public RevisionBuilder(Boolean validationEnabled) {
    this(new Revision(), validationEnabled);
  }
  public RevisionBuilder(RevisionFluent<?> fluent) {
    this(fluent, false);
  }
  public RevisionBuilder(RevisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Revision(), validationEnabled);
  }
  public RevisionBuilder(RevisionFluent<?> fluent,Revision instance) {
    this(fluent, instance, false);
  }
  public RevisionBuilder(RevisionFluent<?> fluent,Revision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RevisionBuilder(Revision instance) {
    this(instance,false);
  }
  public RevisionBuilder(Revision instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  RevisionFluent<?> fluent;
  Boolean validationEnabled;
  public Revision build() {
    Revision buildable = new Revision(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}