package io.fabric8.knative.serving.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RevisionFluentImpl<A extends RevisionFluent<A>> extends BaseFluent<A> implements RevisionFluent<A>{
  public RevisionFluentImpl() {
  }
  public RevisionFluentImpl(Revision instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private RevisionSpecBuilder spec;
  private RevisionStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public RevisionFluentImpl.MetadataNested<A> withNewMetadata() {
    return new RevisionFluentImpl.MetadataNestedImpl();
  }
  public RevisionFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new RevisionFluentImpl.MetadataNestedImpl(item);
  }
  public RevisionFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public RevisionFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public RevisionFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public RevisionSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public RevisionSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(RevisionSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new RevisionSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public RevisionFluentImpl.SpecNested<A> withNewSpec() {
    return new RevisionFluentImpl.SpecNestedImpl();
  }
  public RevisionFluentImpl.SpecNested<A> withNewSpecLike(RevisionSpec item) {
    return new RevisionFluentImpl.SpecNestedImpl(item);
  }
  public RevisionFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public RevisionFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new RevisionSpecBuilder().build());
  }
  public RevisionFluentImpl.SpecNested<A> editOrNewSpecLike(RevisionSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public RevisionStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public RevisionStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(RevisionStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new RevisionStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public RevisionFluentImpl.StatusNested<A> withNewStatus() {
    return new RevisionFluentImpl.StatusNestedImpl();
  }
  public RevisionFluentImpl.StatusNested<A> withNewStatusLike(RevisionStatus item) {
    return new RevisionFluentImpl.StatusNestedImpl(item);
  }
  public RevisionFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public RevisionFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new RevisionStatusBuilder().build());
  }
  public RevisionFluentImpl.StatusNested<A> editOrNewStatusLike(RevisionStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RevisionFluentImpl that = (RevisionFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<RevisionFluentImpl.MetadataNested<N>> implements RevisionFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) RevisionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends RevisionSpecFluentImpl<RevisionFluentImpl.SpecNested<N>> implements RevisionFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(RevisionSpec item) {
      this.builder = new RevisionSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new RevisionSpecBuilder(this);
    }
    RevisionSpecBuilder builder;
    public N and() {
      return (N) RevisionFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends RevisionStatusFluentImpl<RevisionFluentImpl.StatusNested<N>> implements RevisionFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(RevisionStatus item) {
      this.builder = new RevisionStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new RevisionStatusBuilder(this);
    }
    RevisionStatusBuilder builder;
    public N and() {
      return (N) RevisionFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}