package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RevisionTemplateSpecBuilder extends RevisionTemplateSpecFluentImpl<RevisionTemplateSpecBuilder> implements VisitableBuilder<RevisionTemplateSpec,RevisionTemplateSpecBuilder>{
  public RevisionTemplateSpecBuilder() {
    this(false);
  }
  public RevisionTemplateSpecBuilder(Boolean validationEnabled) {
    this(new RevisionTemplateSpec(), validationEnabled);
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RevisionTemplateSpec(), validationEnabled);
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,RevisionTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,RevisionTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpec instance) {
    this(instance,false);
  }
  public RevisionTemplateSpecBuilder(RevisionTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  RevisionTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RevisionTemplateSpec build() {
    RevisionTemplateSpec buildable = new RevisionTemplateSpec(fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  
}