package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteListBuilder extends RouteListFluentImpl<RouteListBuilder> implements VisitableBuilder<RouteList,RouteListBuilder>{
  public RouteListBuilder() {
    this(false);
  }
  public RouteListBuilder(Boolean validationEnabled) {
    this(new RouteList(), validationEnabled);
  }
  public RouteListBuilder(RouteListFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteListBuilder(RouteListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteList(), validationEnabled);
  }
  public RouteListBuilder(RouteListFluent<?> fluent,RouteList instance) {
    this(fluent, instance, false);
  }
  public RouteListBuilder(RouteListFluent<?> fluent,RouteList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteListBuilder(RouteList instance) {
    this(instance,false);
  }
  public RouteListBuilder(RouteList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteListFluent<?> fluent;
  Boolean validationEnabled;
  public RouteList build() {
    RouteList buildable = new RouteList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}