package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteStatusBuilder extends RouteStatusFluentImpl<RouteStatusBuilder> implements VisitableBuilder<RouteStatus,RouteStatusBuilder>{
  public RouteStatusBuilder() {
    this(false);
  }
  public RouteStatusBuilder(Boolean validationEnabled) {
    this(new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance) {
    this(fluent, instance, false);
  }
  public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withTraffic(instance.getTraffic());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteStatusBuilder(RouteStatus instance) {
    this(instance,false);
  }
  public RouteStatusBuilder(RouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withTraffic(instance.getTraffic());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RouteStatus build() {
    RouteStatus buildable = new RouteStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
    return buildable;
  }
  
}