package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>> extends BaseFluent<A> implements RouteStatusFluent<A>{
  public RouteStatusFluentImpl() {
  }
  public RouteStatusFluentImpl(RouteStatus instance) {
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withTraffic(instance.getTraffic());
      this.withUrl(instance.getUrl());
    }
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private Long observedGeneration;
  private ArrayList<TrafficTargetBuilder> traffic = new ArrayList<TrafficTargetBuilder>();
  private String url;
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewAddress(String url) {
    return (A)withAddress(new Addressable(url));
  }
  public RouteStatusFluentImpl.AddressNested<A> withNewAddress() {
    return new RouteStatusFluentImpl.AddressNestedImpl();
  }
  public RouteStatusFluentImpl.AddressNested<A> withNewAddressLike(Addressable item) {
    return new RouteStatusFluentImpl.AddressNestedImpl(item);
  }
  public RouteStatusFluentImpl.AddressNested<A> editAddress() {
    return withNewAddressLike(getAddress());
  }
  public RouteStatusFluentImpl.AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public RouteStatusFluentImpl.AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public RouteStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new RouteStatusFluentImpl.ConditionsNestedImpl();
  }
  public RouteStatusFluentImpl.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new RouteStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public RouteStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new RouteStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public RouteStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RouteStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public RouteStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RouteStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").add(index, builder); traffic.add(index, builder);}
    return (A)this;
  }
  public A setToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").set(index, builder); traffic.set(index, builder);}
    return (A)this;
  }
  public A addToTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A addAllToTraffic(Collection<TrafficTarget> items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A removeFromTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeAllFromTraffic(Collection<TrafficTarget> items) {
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
    if (traffic == null) return (A) this;
    final Iterator<TrafficTargetBuilder> each = traffic.iterator();
    final List visitables = _visitables.get("traffic");
    while (each.hasNext()) {
      TrafficTargetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTraffic instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TrafficTarget> getTraffic() {
    return traffic != null ? build(traffic) : null;
  }
  public List<TrafficTarget> buildTraffic() {
    return traffic != null ? build(traffic) : null;
  }
  public TrafficTarget buildTraffic(int index) {
    return this.traffic.get(index).build();
  }
  public TrafficTarget buildFirstTraffic() {
    return this.traffic.get(0).build();
  }
  public TrafficTarget buildLastTraffic() {
    return this.traffic.get(traffic.size() - 1).build();
  }
  public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTraffic(List<TrafficTarget> traffic) {
    if (this.traffic != null) { _visitables.get("traffic").clear();}
    if (traffic != null) {this.traffic = new ArrayList(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = null;} return (A) this;
  }
  public A withTraffic(io.fabric8.knative.serving.v1.TrafficTarget... traffic) {
    if (this.traffic != null) {this.traffic.clear(); _visitables.remove("traffic"); }
    if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
  }
  public Boolean hasTraffic() {
    return traffic != null && !traffic.isEmpty();
  }
  public RouteStatusFluentImpl.TrafficNested<A> addNewTraffic() {
    return new RouteStatusFluentImpl.TrafficNestedImpl();
  }
  public RouteStatusFluentImpl.TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
    return new RouteStatusFluentImpl.TrafficNestedImpl(-1, item);
  }
  public RouteStatusFluentImpl.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item) {
    return new RouteStatusFluentImpl.TrafficNestedImpl(index, item);
  }
  public RouteStatusFluentImpl.TrafficNested<A> editTraffic(int index) {
    if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public RouteStatusFluentImpl.TrafficNested<A> editFirstTraffic() {
    if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
    return setNewTrafficLike(0, buildTraffic(0));
  }
  public RouteStatusFluentImpl.TrafficNested<A> editLastTraffic() {
    int index = traffic.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public RouteStatusFluentImpl.TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<traffic.size();i++) { 
    if (predicate.test(traffic.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
    if (!java.util.Objects.equals(address, that.address)) return false;

    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(traffic, that.traffic)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  conditions,  observedGeneration,  traffic,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (traffic != null) { sb.append("traffic:"); sb.append(traffic + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class AddressNestedImpl<N> extends AddressableFluentImpl<RouteStatusFluentImpl.AddressNested<N>> implements RouteStatusFluentImpl.AddressNested<N>,Nested<N>{
    AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) RouteStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<RouteStatusFluentImpl.ConditionsNested<N>> implements RouteStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    int index;
    public N and() {
      return (N) RouteStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<RouteStatusFluentImpl.TrafficNested<N>> implements RouteStatusFluentImpl.TrafficNested<N>,Nested<N>{
    TrafficNestedImpl(int index,TrafficTarget item) {
      this.index = index;
      this.builder = new TrafficTargetBuilder(this, item);
    }
    TrafficNestedImpl() {
      this.index = -1;
      this.builder = new TrafficTargetBuilder(this);
    }
    TrafficTargetBuilder builder;
    int index;
    public N and() {
      return (N) RouteStatusFluentImpl.this.setToTraffic(index,builder.build());
    }
    public N endTraffic() {
      return and();
    }
    
  }
  
}