package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>> extends BaseFluent<A> implements ServiceSpecFluent<A>{
  public ServiceSpecFluentImpl() {
  }
  public ServiceSpecFluentImpl(ServiceSpec instance) {
    if (instance != null) {
      this.withTemplate(instance.getTemplate());
      this.withTraffic(instance.getTraffic());
    }
  }
  private RevisionTemplateSpecBuilder template;
  private ArrayList<TrafficTargetBuilder> traffic = new ArrayList<TrafficTargetBuilder>();
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public RevisionTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public RevisionTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(RevisionTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new RevisionTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public ServiceSpecFluentImpl.TemplateNested<A> withNewTemplate() {
    return new ServiceSpecFluentImpl.TemplateNestedImpl();
  }
  public ServiceSpecFluentImpl.TemplateNested<A> withNewTemplateLike(RevisionTemplateSpec item) {
    return new ServiceSpecFluentImpl.TemplateNestedImpl(item);
  }
  public ServiceSpecFluentImpl.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public ServiceSpecFluentImpl.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new RevisionTemplateSpecBuilder().build());
  }
  public ServiceSpecFluentImpl.TemplateNested<A> editOrNewTemplateLike(RevisionTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").add(index, builder); traffic.add(index, builder);}
    return (A)this;
  }
  public A setToTraffic(int index,TrafficTarget item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").set(index, builder); traffic.set(index, builder);}
    return (A)this;
  }
  public A addToTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A addAllToTraffic(Collection<TrafficTarget> items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A removeFromTraffic(io.fabric8.knative.serving.v1.TrafficTarget... items) {
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeAllFromTraffic(Collection<TrafficTarget> items) {
    for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
    if (traffic == null) return (A) this;
    final Iterator<TrafficTargetBuilder> each = traffic.iterator();
    final List visitables = _visitables.get("traffic");
    while (each.hasNext()) {
      TrafficTargetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTraffic instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TrafficTarget> getTraffic() {
    return traffic != null ? build(traffic) : null;
  }
  public List<TrafficTarget> buildTraffic() {
    return traffic != null ? build(traffic) : null;
  }
  public TrafficTarget buildTraffic(int index) {
    return this.traffic.get(index).build();
  }
  public TrafficTarget buildFirstTraffic() {
    return this.traffic.get(0).build();
  }
  public TrafficTarget buildLastTraffic() {
    return this.traffic.get(traffic.size() - 1).build();
  }
  public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTraffic(List<TrafficTarget> traffic) {
    if (this.traffic != null) { _visitables.get("traffic").clear();}
    if (traffic != null) {this.traffic = new ArrayList(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = null;} return (A) this;
  }
  public A withTraffic(io.fabric8.knative.serving.v1.TrafficTarget... traffic) {
    if (this.traffic != null) {this.traffic.clear(); _visitables.remove("traffic"); }
    if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
  }
  public Boolean hasTraffic() {
    return traffic != null && !traffic.isEmpty();
  }
  public ServiceSpecFluentImpl.TrafficNested<A> addNewTraffic() {
    return new ServiceSpecFluentImpl.TrafficNestedImpl();
  }
  public ServiceSpecFluentImpl.TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
    return new ServiceSpecFluentImpl.TrafficNestedImpl(-1, item);
  }
  public ServiceSpecFluentImpl.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item) {
    return new ServiceSpecFluentImpl.TrafficNestedImpl(index, item);
  }
  public ServiceSpecFluentImpl.TrafficNested<A> editTraffic(int index) {
    if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public ServiceSpecFluentImpl.TrafficNested<A> editFirstTraffic() {
    if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
    return setNewTrafficLike(0, buildTraffic(0));
  }
  public ServiceSpecFluentImpl.TrafficNested<A> editLastTraffic() {
    int index = traffic.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public ServiceSpecFluentImpl.TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<traffic.size();i++) { 
    if (predicate.test(traffic.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(traffic, that.traffic)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(template,  traffic,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (traffic != null) { sb.append("traffic:"); sb.append(traffic); }
    sb.append("}");
    return sb.toString();
  }
  class TemplateNestedImpl<N> extends RevisionTemplateSpecFluentImpl<ServiceSpecFluentImpl.TemplateNested<N>> implements ServiceSpecFluentImpl.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(RevisionTemplateSpec item) {
      this.builder = new RevisionTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new RevisionTemplateSpecBuilder(this);
    }
    RevisionTemplateSpecBuilder builder;
    public N and() {
      return (N) ServiceSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<ServiceSpecFluentImpl.TrafficNested<N>> implements ServiceSpecFluentImpl.TrafficNested<N>,Nested<N>{
    TrafficNestedImpl(int index,TrafficTarget item) {
      this.index = index;
      this.builder = new TrafficTargetBuilder(this, item);
    }
    TrafficNestedImpl() {
      this.index = -1;
      this.builder = new TrafficTargetBuilder(this);
    }
    TrafficTargetBuilder builder;
    int index;
    public N and() {
      return (N) ServiceSpecFluentImpl.this.setToTraffic(index,builder.build());
    }
    public N endTraffic() {
      return and();
    }
    
  }
  
}