package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceStatusBuilder extends ServiceStatusFluentImpl<ServiceStatusBuilder> implements VisitableBuilder<ServiceStatus,ServiceStatusBuilder>{
  public ServiceStatusBuilder() {
    this(false);
  }
  public ServiceStatusBuilder(Boolean validationEnabled) {
    this(new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
      fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withTraffic(instance.getTraffic());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceStatusBuilder(ServiceStatus instance) {
    this(instance,false);
  }
  public ServiceStatusBuilder(ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
      this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withTraffic(instance.getTraffic());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceStatus build() {
    ServiceStatus buildable = new ServiceStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
    return buildable;
  }
  
}