package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DomainMappingBuilder extends DomainMappingFluentImpl<DomainMappingBuilder> implements VisitableBuilder<DomainMapping,DomainMappingBuilder>{
  public DomainMappingBuilder() {
    this(false);
  }
  public DomainMappingBuilder(Boolean validationEnabled) {
    this(new DomainMapping(), validationEnabled);
  }
  public DomainMappingBuilder(DomainMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public DomainMappingBuilder(DomainMappingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DomainMapping(), validationEnabled);
  }
  public DomainMappingBuilder(DomainMappingFluent<?> fluent,DomainMapping instance) {
    this(fluent, instance, false);
  }
  public DomainMappingBuilder(DomainMappingFluent<?> fluent,DomainMapping instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DomainMappingBuilder(DomainMapping instance) {
    this(instance,false);
  }
  public DomainMappingBuilder(DomainMapping instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  DomainMappingFluent<?> fluent;
  Boolean validationEnabled;
  public DomainMapping build() {
    DomainMapping buildable = new DomainMapping(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}