package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DomainMappingListFluentImpl<A extends DomainMappingListFluent<A>> extends BaseFluent<A> implements DomainMappingListFluent<A>{
  public DomainMappingListFluentImpl() {
  }
  public DomainMappingListFluentImpl(DomainMappingList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<DomainMappingBuilder> items = new ArrayList<DomainMappingBuilder>();
  private String kind;
  private ListMeta metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,DomainMapping item) {
    if (this.items == null) {this.items = new ArrayList<DomainMappingBuilder>();}
    DomainMappingBuilder builder = new DomainMappingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,DomainMapping item) {
    if (this.items == null) {this.items = new ArrayList<DomainMappingBuilder>();}
    DomainMappingBuilder builder = new DomainMappingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.knative.serving.v1beta1.DomainMapping... items) {
    if (this.items == null) {this.items = new ArrayList<DomainMappingBuilder>();}
    for (DomainMapping item : items) {DomainMappingBuilder builder = new DomainMappingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<DomainMapping> items) {
    if (this.items == null) {this.items = new ArrayList<DomainMappingBuilder>();}
    for (DomainMapping item : items) {DomainMappingBuilder builder = new DomainMappingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.knative.serving.v1beta1.DomainMapping... items) {
    for (DomainMapping item : items) {DomainMappingBuilder builder = new DomainMappingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<DomainMapping> items) {
    for (DomainMapping item : items) {DomainMappingBuilder builder = new DomainMappingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<DomainMappingBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<DomainMappingBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      DomainMappingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DomainMapping> getItems() {
    return items != null ? build(items) : null;
  }
  public List<DomainMapping> buildItems() {
    return items != null ? build(items) : null;
  }
  public DomainMapping buildItem(int index) {
    return this.items.get(index).build();
  }
  public DomainMapping buildFirstItem() {
    return this.items.get(0).build();
  }
  public DomainMapping buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public DomainMapping buildMatchingItem(Predicate<DomainMappingBuilder> predicate) {
    for (DomainMappingBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<DomainMappingBuilder> predicate) {
    for (DomainMappingBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<DomainMapping> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (DomainMapping item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.knative.serving.v1beta1.DomainMapping... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (DomainMapping item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public DomainMappingListFluentImpl.ItemsNested<A> addNewItem() {
    return new DomainMappingListFluentImpl.ItemsNestedImpl();
  }
  public DomainMappingListFluentImpl.ItemsNested<A> addNewItemLike(DomainMapping item) {
    return new DomainMappingListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public DomainMappingListFluentImpl.ItemsNested<A> setNewItemLike(int index,DomainMapping item) {
    return new DomainMappingListFluentImpl.ItemsNestedImpl(index, item);
  }
  public DomainMappingListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public DomainMappingListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public DomainMappingListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public DomainMappingListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<DomainMappingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DomainMappingListFluentImpl that = (DomainMappingListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends DomainMappingFluentImpl<DomainMappingListFluentImpl.ItemsNested<N>> implements DomainMappingListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,DomainMapping item) {
      this.index = index;
      this.builder = new DomainMappingBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new DomainMappingBuilder(this);
    }
    DomainMappingBuilder builder;
    int index;
    public N and() {
      return (N) DomainMappingListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}