package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretTLSBuilder extends SecretTLSFluentImpl<SecretTLSBuilder> implements VisitableBuilder<SecretTLS,SecretTLSBuilder>{
  public SecretTLSBuilder() {
    this(false);
  }
  public SecretTLSBuilder(Boolean validationEnabled) {
    this(new SecretTLS(), validationEnabled);
  }
  public SecretTLSBuilder(SecretTLSFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretTLSBuilder(SecretTLSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretTLS(), validationEnabled);
  }
  public SecretTLSBuilder(SecretTLSFluent<?> fluent,SecretTLS instance) {
    this(fluent, instance, false);
  }
  public SecretTLSBuilder(SecretTLSFluent<?> fluent,SecretTLS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretTLSBuilder(SecretTLS instance) {
    this(instance,false);
  }
  public SecretTLSBuilder(SecretTLS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretTLSFluent<?> fluent;
  Boolean validationEnabled;
  public SecretTLS build() {
    SecretTLS buildable = new SecretTLS(fluent.getSecretName());
    return buildable;
  }
  
}