package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIVersionKindBuilder extends APIVersionKindFluentImpl<APIVersionKindBuilder> implements VisitableBuilder<APIVersionKind,APIVersionKindBuilder>{
  public APIVersionKindBuilder() {
    this(false);
  }
  public APIVersionKindBuilder(Boolean validationEnabled) {
    this(new APIVersionKind(), validationEnabled);
  }
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent) {
    this(fluent, false);
  }
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIVersionKind(), validationEnabled);
  }
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,APIVersionKind instance) {
    this(fluent, instance, false);
  }
  public APIVersionKindBuilder(APIVersionKindFluent<?> fluent,APIVersionKind instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIVersionKindBuilder(APIVersionKind instance) {
    this(instance,false);
  }
  public APIVersionKindBuilder(APIVersionKind instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIVersionKindFluent<?> fluent;
  Boolean validationEnabled;
  public APIVersionKind build() {
    APIVersionKind buildable = new APIVersionKind(fluent.getApiVersion(),fluent.getKind());
    return buildable;
  }
  
}