package io.fabric8.knative.sources.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApiServerSourceFluentImpl<A extends ApiServerSourceFluent<A>> extends BaseFluent<A> implements ApiServerSourceFluent<A>{
  public ApiServerSourceFluentImpl() {
  }
  public ApiServerSourceFluentImpl(ApiServerSource instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ApiServerSourceSpecBuilder spec;
  private ApiServerSourceStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ApiServerSourceFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ApiServerSourceFluentImpl.MetadataNestedImpl();
  }
  public ApiServerSourceFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ApiServerSourceFluentImpl.MetadataNestedImpl(item);
  }
  public ApiServerSourceFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ApiServerSourceFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ApiServerSourceFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ApiServerSourceSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ApiServerSourceSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ApiServerSourceSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ApiServerSourceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ApiServerSourceFluentImpl.SpecNested<A> withNewSpec() {
    return new ApiServerSourceFluentImpl.SpecNestedImpl();
  }
  public ApiServerSourceFluentImpl.SpecNested<A> withNewSpecLike(ApiServerSourceSpec item) {
    return new ApiServerSourceFluentImpl.SpecNestedImpl(item);
  }
  public ApiServerSourceFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ApiServerSourceFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ApiServerSourceSpecBuilder().build());
  }
  public ApiServerSourceFluentImpl.SpecNested<A> editOrNewSpecLike(ApiServerSourceSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ApiServerSourceStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ApiServerSourceStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ApiServerSourceStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ApiServerSourceStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ApiServerSourceFluentImpl.StatusNested<A> withNewStatus() {
    return new ApiServerSourceFluentImpl.StatusNestedImpl();
  }
  public ApiServerSourceFluentImpl.StatusNested<A> withNewStatusLike(ApiServerSourceStatus item) {
    return new ApiServerSourceFluentImpl.StatusNestedImpl(item);
  }
  public ApiServerSourceFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ApiServerSourceFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ApiServerSourceStatusBuilder().build());
  }
  public ApiServerSourceFluentImpl.StatusNested<A> editOrNewStatusLike(ApiServerSourceStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApiServerSourceFluentImpl that = (ApiServerSourceFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ApiServerSourceFluentImpl.MetadataNested<N>> implements ApiServerSourceFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ApiServerSourceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ApiServerSourceSpecFluentImpl<ApiServerSourceFluentImpl.SpecNested<N>> implements ApiServerSourceFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ApiServerSourceSpec item) {
      this.builder = new ApiServerSourceSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ApiServerSourceSpecBuilder(this);
    }
    ApiServerSourceSpecBuilder builder;
    public N and() {
      return (N) ApiServerSourceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ApiServerSourceStatusFluentImpl<ApiServerSourceFluentImpl.StatusNested<N>> implements ApiServerSourceFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ApiServerSourceStatus item) {
      this.builder = new ApiServerSourceStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ApiServerSourceStatusBuilder(this);
    }
    ApiServerSourceStatusBuilder builder;
    public N and() {
      return (N) ApiServerSourceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}