package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApiServerSourceSpecBuilder extends ApiServerSourceSpecFluentImpl<ApiServerSourceSpecBuilder> implements VisitableBuilder<ApiServerSourceSpec,ApiServerSourceSpecBuilder>{
  public ApiServerSourceSpecBuilder() {
    this(false);
  }
  public ApiServerSourceSpecBuilder(Boolean validationEnabled) {
    this(new ApiServerSourceSpec(), validationEnabled);
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApiServerSourceSpec(), validationEnabled);
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent,ApiServerSourceSpec instance) {
    this(fluent, instance, false);
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpecFluent<?> fluent,ApiServerSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withMode(instance.getMode());
      fluent.withOwner(instance.getOwner());
      fluent.withResources(instance.getResources());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpec instance) {
    this(instance,false);
  }
  public ApiServerSourceSpecBuilder(ApiServerSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCeOverrides(instance.getCeOverrides());
      this.withMode(instance.getMode());
      this.withOwner(instance.getOwner());
      this.withResources(instance.getResources());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
    }
    this.validationEnabled = validationEnabled; 
  }
  ApiServerSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ApiServerSourceSpec build() {
    ApiServerSourceSpec buildable = new ApiServerSourceSpec(fluent.getCeOverrides(),fluent.getMode(),fluent.getOwner(),fluent.getResources(),fluent.getServiceAccountName(),fluent.getSink());
    return buildable;
  }
  
}