package io.fabric8.knative.sources.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApiServerSourceSpecFluentImpl<A extends ApiServerSourceSpecFluent<A>> extends BaseFluent<A> implements ApiServerSourceSpecFluent<A>{
  public ApiServerSourceSpecFluentImpl() {
  }
  public ApiServerSourceSpecFluentImpl(ApiServerSourceSpec instance) {
    if (instance != null) {
      this.withCeOverrides(instance.getCeOverrides());
      this.withMode(instance.getMode());
      this.withOwner(instance.getOwner());
      this.withResources(instance.getResources());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSink(instance.getSink());
    }
  }
  private CloudEventOverridesBuilder ceOverrides;
  private String mode;
  private APIVersionKindBuilder owner;
  private ArrayList<APIVersionKindSelectorBuilder> resources = new ArrayList<APIVersionKindSelectorBuilder>();
  private String serviceAccountName;
  private DestinationBuilder sink;
  
  /**
   * This method has been deprecated, please use method buildCeOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public CloudEventOverrides getCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public CloudEventOverrides buildCeOverrides() {
    return this.ceOverrides!=null ?this.ceOverrides.build():null;
  }
  public A withCeOverrides(CloudEventOverrides ceOverrides) {
    _visitables.get("ceOverrides").remove(this.ceOverrides);
    if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} else { this.ceOverrides = null; _visitables.get("ceOverrides").remove(this.ceOverrides); } return (A) this;
  }
  public Boolean hasCeOverrides() {
    return this.ceOverrides != null;
  }
  public ApiServerSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverrides() {
    return new ApiServerSourceSpecFluentImpl.CeOverridesNestedImpl();
  }
  public ApiServerSourceSpecFluentImpl.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
    return new ApiServerSourceSpecFluentImpl.CeOverridesNestedImpl(item);
  }
  public ApiServerSourceSpecFluentImpl.CeOverridesNested<A> editCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides());
  }
  public ApiServerSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverrides() {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
  }
  public ApiServerSourceSpecFluentImpl.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
    return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOwner instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIVersionKind getOwner() {
    return this.owner!=null ?this.owner.build():null;
  }
  public APIVersionKind buildOwner() {
    return this.owner!=null ?this.owner.build():null;
  }
  public A withOwner(APIVersionKind owner) {
    _visitables.get("owner").remove(this.owner);
    if (owner!=null){ this.owner= new APIVersionKindBuilder(owner); _visitables.get("owner").add(this.owner);} else { this.owner = null; _visitables.get("owner").remove(this.owner); } return (A) this;
  }
  public Boolean hasOwner() {
    return this.owner != null;
  }
  public A withNewOwner(String apiVersion,String kind) {
    return (A)withOwner(new APIVersionKind(apiVersion, kind));
  }
  public ApiServerSourceSpecFluentImpl.OwnerNested<A> withNewOwner() {
    return new ApiServerSourceSpecFluentImpl.OwnerNestedImpl();
  }
  public ApiServerSourceSpecFluentImpl.OwnerNested<A> withNewOwnerLike(APIVersionKind item) {
    return new ApiServerSourceSpecFluentImpl.OwnerNestedImpl(item);
  }
  public ApiServerSourceSpecFluentImpl.OwnerNested<A> editOwner() {
    return withNewOwnerLike(getOwner());
  }
  public ApiServerSourceSpecFluentImpl.OwnerNested<A> editOrNewOwner() {
    return withNewOwnerLike(getOwner() != null ? getOwner(): new APIVersionKindBuilder().build());
  }
  public ApiServerSourceSpecFluentImpl.OwnerNested<A> editOrNewOwnerLike(APIVersionKind item) {
    return withNewOwnerLike(getOwner() != null ? getOwner(): item);
  }
  public A addToResources(int index,APIVersionKindSelector item) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").add(index, builder); resources.add(index, builder);}
    return (A)this;
  }
  public A setToResources(int index,APIVersionKindSelector item) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").set(index, builder); resources.set(index, builder);}
    return (A)this;
  }
  public A addToResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... items) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(Collection<APIVersionKindSelector> items) {
    if (this.resources == null) {this.resources = new ArrayList<APIVersionKindSelectorBuilder>();}
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... items) {
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(Collection<APIVersionKindSelector> items) {
    for (APIVersionKindSelector item : items) {APIVersionKindSelectorBuilder builder = new APIVersionKindSelectorBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(Predicate<APIVersionKindSelectorBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<APIVersionKindSelectorBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      APIVersionKindSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<APIVersionKindSelector> getResources() {
    return resources != null ? build(resources) : null;
  }
  public List<APIVersionKindSelector> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public APIVersionKindSelector buildResource(int index) {
    return this.resources.get(index).build();
  }
  public APIVersionKindSelector buildFirstResource() {
    return this.resources.get(0).build();
  }
  public APIVersionKindSelector buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public APIVersionKindSelector buildMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
    for (APIVersionKindSelectorBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
    for (APIVersionKindSelectorBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<APIVersionKindSelector> resources) {
    if (this.resources != null) { _visitables.get("resources").clear();}
    if (resources != null) {this.resources = new ArrayList(); for (APIVersionKindSelector item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.knative.sources.v1.APIVersionKindSelector... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (APIVersionKindSelector item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> addNewResource() {
    return new ApiServerSourceSpecFluentImpl.ResourcesNestedImpl();
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> addNewResourceLike(APIVersionKindSelector item) {
    return new ApiServerSourceSpecFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> setNewResourceLike(int index,APIVersionKindSelector item) {
    return new ApiServerSourceSpecFluentImpl.ResourcesNestedImpl(index, item);
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> editResource(int index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public ApiServerSourceSpecFluentImpl.ResourcesNested<A> editMatchingResource(Predicate<APIVersionKindSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSink instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public Destination buildSink() {
    return this.sink!=null ?this.sink.build():null;
  }
  public A withSink(Destination sink) {
    _visitables.get("sink").remove(this.sink);
    if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} else { this.sink = null; _visitables.get("sink").remove(this.sink); } return (A) this;
  }
  public Boolean hasSink() {
    return this.sink != null;
  }
  public ApiServerSourceSpecFluentImpl.SinkNested<A> withNewSink() {
    return new ApiServerSourceSpecFluentImpl.SinkNestedImpl();
  }
  public ApiServerSourceSpecFluentImpl.SinkNested<A> withNewSinkLike(Destination item) {
    return new ApiServerSourceSpecFluentImpl.SinkNestedImpl(item);
  }
  public ApiServerSourceSpecFluentImpl.SinkNested<A> editSink() {
    return withNewSinkLike(getSink());
  }
  public ApiServerSourceSpecFluentImpl.SinkNested<A> editOrNewSink() {
    return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
  }
  public ApiServerSourceSpecFluentImpl.SinkNested<A> editOrNewSinkLike(Destination item) {
    return withNewSinkLike(getSink() != null ? getSink(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApiServerSourceSpecFluentImpl that = (ApiServerSourceSpecFluentImpl) o;
    if (!java.util.Objects.equals(ceOverrides, that.ceOverrides)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(owner, that.owner)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sink, that.sink)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ceOverrides,  mode,  owner,  resources,  serviceAccountName,  sink,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ceOverrides != null) { sb.append("ceOverrides:"); sb.append(ceOverrides + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (owner != null) { sb.append("owner:"); sb.append(owner + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sink != null) { sb.append("sink:"); sb.append(sink); }
    sb.append("}");
    return sb.toString();
  }
  class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<ApiServerSourceSpecFluentImpl.CeOverridesNested<N>> implements ApiServerSourceSpecFluentImpl.CeOverridesNested<N>,Nested<N>{
    CeOverridesNestedImpl(CloudEventOverrides item) {
      this.builder = new CloudEventOverridesBuilder(this, item);
    }
    CeOverridesNestedImpl() {
      this.builder = new CloudEventOverridesBuilder(this);
    }
    CloudEventOverridesBuilder builder;
    public N and() {
      return (N) ApiServerSourceSpecFluentImpl.this.withCeOverrides(builder.build());
    }
    public N endCeOverrides() {
      return and();
    }
    
  }
  class OwnerNestedImpl<N> extends APIVersionKindFluentImpl<ApiServerSourceSpecFluentImpl.OwnerNested<N>> implements ApiServerSourceSpecFluentImpl.OwnerNested<N>,Nested<N>{
    OwnerNestedImpl(APIVersionKind item) {
      this.builder = new APIVersionKindBuilder(this, item);
    }
    OwnerNestedImpl() {
      this.builder = new APIVersionKindBuilder(this);
    }
    APIVersionKindBuilder builder;
    public N and() {
      return (N) ApiServerSourceSpecFluentImpl.this.withOwner(builder.build());
    }
    public N endOwner() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends APIVersionKindSelectorFluentImpl<ApiServerSourceSpecFluentImpl.ResourcesNested<N>> implements ApiServerSourceSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(int index,APIVersionKindSelector item) {
      this.index = index;
      this.builder = new APIVersionKindSelectorBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new APIVersionKindSelectorBuilder(this);
    }
    APIVersionKindSelectorBuilder builder;
    int index;
    public N and() {
      return (N) ApiServerSourceSpecFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  class SinkNestedImpl<N> extends DestinationFluentImpl<ApiServerSourceSpecFluentImpl.SinkNested<N>> implements ApiServerSourceSpecFluentImpl.SinkNested<N>,Nested<N>{
    SinkNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SinkNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) ApiServerSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endSink() {
      return and();
    }
    
  }
  
}