package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerSourceBuilder extends ContainerSourceFluentImpl<ContainerSourceBuilder> implements VisitableBuilder<ContainerSource,ContainerSourceBuilder>{
  public ContainerSourceBuilder() {
    this(false);
  }
  public ContainerSourceBuilder(Boolean validationEnabled) {
    this(new ContainerSource(), validationEnabled);
  }
  public ContainerSourceBuilder(ContainerSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerSourceBuilder(ContainerSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerSource(), validationEnabled);
  }
  public ContainerSourceBuilder(ContainerSourceFluent<?> fluent,ContainerSource instance) {
    this(fluent, instance, false);
  }
  public ContainerSourceBuilder(ContainerSourceFluent<?> fluent,ContainerSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerSourceBuilder(ContainerSource instance) {
    this(instance,false);
  }
  public ContainerSourceBuilder(ContainerSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerSource build() {
    ContainerSource buildable = new ContainerSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}