package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerSourceListBuilder extends ContainerSourceListFluentImpl<ContainerSourceListBuilder> implements VisitableBuilder<ContainerSourceList,ContainerSourceListBuilder>{
  public ContainerSourceListBuilder() {
    this(false);
  }
  public ContainerSourceListBuilder(Boolean validationEnabled) {
    this(new ContainerSourceList(), validationEnabled);
  }
  public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerSourceList(), validationEnabled);
  }
  public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,ContainerSourceList instance) {
    this(fluent, instance, false);
  }
  public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,ContainerSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerSourceListBuilder(ContainerSourceList instance) {
    this(instance,false);
  }
  public ContainerSourceListBuilder(ContainerSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerSourceList build() {
    ContainerSourceList buildable = new ContainerSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}