package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PingSourceStatusBuilder extends PingSourceStatusFluentImpl<PingSourceStatusBuilder> implements VisitableBuilder<PingSourceStatus,PingSourceStatusBuilder>{
  public PingSourceStatusBuilder() {
    this(false);
  }
  public PingSourceStatusBuilder(Boolean validationEnabled) {
    this(new PingSourceStatus(), validationEnabled);
  }
  public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PingSourceStatus(), validationEnabled);
  }
  public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,PingSourceStatus instance) {
    this(fluent, instance, false);
  }
  public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,PingSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PingSourceStatusBuilder(PingSourceStatus instance) {
    this(instance,false);
  }
  public PingSourceStatusBuilder(PingSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  PingSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PingSourceStatus build() {
    PingSourceStatus buildable = new PingSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}