package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SinkBindingBuilder extends SinkBindingFluentImpl<SinkBindingBuilder> implements VisitableBuilder<SinkBinding,SinkBindingBuilder>{
  public SinkBindingBuilder() {
    this(false);
  }
  public SinkBindingBuilder(Boolean validationEnabled) {
    this(new SinkBinding(), validationEnabled);
  }
  public SinkBindingBuilder(SinkBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public SinkBindingBuilder(SinkBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SinkBinding(), validationEnabled);
  }
  public SinkBindingBuilder(SinkBindingFluent<?> fluent,SinkBinding instance) {
    this(fluent, instance, false);
  }
  public SinkBindingBuilder(SinkBindingFluent<?> fluent,SinkBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SinkBindingBuilder(SinkBinding instance) {
    this(instance,false);
  }
  public SinkBindingBuilder(SinkBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  SinkBindingFluent<?> fluent;
  Boolean validationEnabled;
  public SinkBinding build() {
    SinkBinding buildable = new SinkBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}