package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SinkBindingListBuilder extends SinkBindingListFluentImpl<SinkBindingListBuilder> implements VisitableBuilder<SinkBindingList,SinkBindingListBuilder>{
  public SinkBindingListBuilder() {
    this(false);
  }
  public SinkBindingListBuilder(Boolean validationEnabled) {
    this(new SinkBindingList(), validationEnabled);
  }
  public SinkBindingListBuilder(SinkBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SinkBindingList(), validationEnabled);
  }
  public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,SinkBindingList instance) {
    this(fluent, instance, false);
  }
  public SinkBindingListBuilder(SinkBindingListFluent<?> fluent,SinkBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SinkBindingListBuilder(SinkBindingList instance) {
    this(instance,false);
  }
  public SinkBindingListBuilder(SinkBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  SinkBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public SinkBindingList build() {
    SinkBindingList buildable = new SinkBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}