package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SinkBindingStatusBuilder extends SinkBindingStatusFluentImpl<SinkBindingStatusBuilder> implements VisitableBuilder<SinkBindingStatus,SinkBindingStatusBuilder>{
  public SinkBindingStatusBuilder() {
    this(false);
  }
  public SinkBindingStatusBuilder(Boolean validationEnabled) {
    this(new SinkBindingStatus(), validationEnabled);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SinkBindingStatus(), validationEnabled);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance) {
    this(fluent, instance, false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatusFluent<?> fluent,SinkBindingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SinkBindingStatusBuilder(SinkBindingStatus instance) {
    this(instance,false);
  }
  public SinkBindingStatusBuilder(SinkBindingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  SinkBindingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SinkBindingStatus build() {
    SinkBindingStatus buildable = new SinkBindingStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}