/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingBuilder;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingFluentImpl;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingList;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class GitHubBindingListFluentImpl<A extends GitHubBindingListFluent<A>>
extends BaseFluent<A>
implements GitHubBindingListFluent<A> {
    private String apiVersion;
    private ArrayList<GitHubBindingBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public GitHubBindingListFluentImpl() {
    }

    public GitHubBindingListFluentImpl(GitHubBindingList instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, GitHubBinding item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, GitHubBinding item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(GitHubBinding ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (GitHubBinding item : items) {
            GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<GitHubBinding> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (GitHubBinding item : items) {
            GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(GitHubBinding ... items) {
        for (GitHubBinding item : items) {
            GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<GitHubBinding> items) {
        for (GitHubBinding item : items) {
            GitHubBindingBuilder builder = new GitHubBindingBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<GitHubBindingBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<GitHubBindingBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            GitHubBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GitHubBinding> getItems() {
        return this.items != null ? GitHubBindingListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<GitHubBinding> buildItems() {
        return this.items != null ? GitHubBindingListFluentImpl.build(this.items) : null;
    }

    @Override
    public GitHubBinding buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public GitHubBinding buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public GitHubBinding buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public GitHubBinding buildMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
        for (GitHubBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
        for (GitHubBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<GitHubBinding> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (GitHubBinding item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(GitHubBinding ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (GitHubBinding item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> addNewItemLike(GitHubBinding item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> setNewItemLike(int index, GitHubBinding item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public GitHubBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<GitHubBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitHubBindingListFluentImpl that = (GitHubBindingListFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends GitHubBindingFluentImpl<GitHubBindingListFluent.ItemsNested<N>>
    implements GitHubBindingListFluent.ItemsNested<N>,
    Nested<N> {
        GitHubBindingBuilder builder;
        int index;

        ItemsNestedImpl(int index, GitHubBinding item) {
            this.index = index;
            this.builder = new GitHubBindingBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new GitHubBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)GitHubBindingListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

