/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.knative.messaging.v1.InMemoryChannelSpec;
import io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class InMemoryChannelSpecFluentImpl<A extends InMemoryChannelSpecFluent<A>>
extends BaseFluent<A>
implements InMemoryChannelSpecFluent<A> {
    private DeliverySpecBuilder delivery;
    private ArrayList<SubscriberSpecBuilder> subscribers = new ArrayList();

    public InMemoryChannelSpecFluentImpl() {
    }

    public InMemoryChannelSpecFluentImpl(InMemoryChannelSpec instance) {
        if (instance != null) {
            this.withDelivery(instance.getDelivery());
            this.withSubscribers(instance.getSubscribers());
        }
    }

    @Override
    @Deprecated
    public DeliverySpec getDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove(this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove(this.delivery);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    @Override
    public InMemoryChannelSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    @Override
    public InMemoryChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    @Override
    public InMemoryChannelSpecFluent.DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(this.getDelivery());
    }

    @Override
    public InMemoryChannelSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : new DeliverySpecBuilder().build());
    }

    @Override
    public InMemoryChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : item);
    }

    @Override
    public A addToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").add(index, builder);
            this.subscribers.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").set(index, builder);
            this.subscribers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubscribers(SubscriberSpec ... items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubscribers(SubscriberSpec ... items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
        if (this.subscribers == null) {
            return (A)this;
        }
        Iterator<SubscriberSpecBuilder> each = this.subscribers.iterator();
        List visitables = this._visitables.get((Object)"subscribers");
        while (each.hasNext()) {
            SubscriberSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SubscriberSpec> getSubscribers() {
        return this.subscribers != null ? InMemoryChannelSpecFluentImpl.build(this.subscribers) : null;
    }

    @Override
    public List<SubscriberSpec> buildSubscribers() {
        return this.subscribers != null ? InMemoryChannelSpecFluentImpl.build(this.subscribers) : null;
    }

    @Override
    public SubscriberSpec buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    @Override
    public SubscriberSpec buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    @Override
    public SubscriberSpec buildLastSubscriber() {
        return this.subscribers.get(this.subscribers.size() - 1).build();
    }

    @Override
    public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubscribers(List<SubscriberSpec> subscribers) {
        if (this.subscribers != null) {
            this._visitables.get((Object)"subscribers").clear();
        }
        if (subscribers != null) {
            this.subscribers = new ArrayList();
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        } else {
            this.subscribers = null;
        }
        return (A)this;
    }

    @Override
    public A withSubscribers(SubscriberSpec ... subscribers) {
        if (this.subscribers != null) {
            this.subscribers.clear();
            this._visitables.remove((Object)"subscribers");
        }
        if (subscribers != null) {
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubscribers() {
        return this.subscribers != null && !this.subscribers.isEmpty();
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
        return new SubscribersNestedImpl(-1, item);
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> setNewSubscriberLike(int index, SubscriberSpec item) {
        return new SubscribersNestedImpl(index, item);
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> editSubscriber(int index) {
        if (this.subscribers.size() <= index) {
            throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> editFirstSubscriber() {
        if (this.subscribers.size() == 0) {
            throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(0, this.buildSubscriber(0));
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> editLastSubscriber() {
        int index = this.subscribers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public InMemoryChannelSpecFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!predicate.test(this.subscribers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subscribers. No match found.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InMemoryChannelSpecFluentImpl that = (InMemoryChannelSpecFluentImpl)o;
        if (!Objects.equals(this.delivery, that.delivery)) {
            return false;
        }
        return Objects.equals(this.subscribers, that.subscribers);
    }

    public int hashCode() {
        return Objects.hash(this.delivery, this.subscribers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append(this.delivery + ",");
        }
        if (this.subscribers != null) {
            sb.append("subscribers:");
            sb.append(this.subscribers);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubscribersNestedImpl<N>
    extends SubscriberSpecFluentImpl<InMemoryChannelSpecFluent.SubscribersNested<N>>
    implements InMemoryChannelSpecFluent.SubscribersNested<N>,
    Nested<N> {
        SubscriberSpecBuilder builder;
        int index;

        SubscribersNestedImpl(int index, SubscriberSpec item) {
            this.index = index;
            this.builder = new SubscriberSpecBuilder(this, item);
        }

        SubscribersNestedImpl() {
            this.index = -1;
            this.builder = new SubscriberSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)InMemoryChannelSpecFluentImpl.this.setToSubscribers(this.index, this.builder.build());
        }

        @Override
        public N endSubscriber() {
            return this.and();
        }
    }

    class DeliveryNestedImpl<N>
    extends DeliverySpecFluentImpl<InMemoryChannelSpecFluent.DeliveryNested<N>>
    implements InMemoryChannelSpecFluent.DeliveryNested<N>,
    Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)InMemoryChannelSpecFluentImpl.this.withDelivery(this.builder.build());
        }

        @Override
        public N endDelivery() {
            return this.and();
        }
    }
}

