package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubBindingSpecBuilder extends GitHubBindingSpecFluent<GitHubBindingSpecBuilder> implements VisitableBuilder<GitHubBindingSpec,GitHubBindingSpecBuilder>{
  public GitHubBindingSpecBuilder() {
    this(false);
  }
  public GitHubBindingSpecBuilder(Boolean validationEnabled) {
    this(new GitHubBindingSpec(), validationEnabled);
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubBindingSpec(), validationEnabled);
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,GitHubBindingSpec instance) {
    this(fluent, instance, false);
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpecFluent<?> fluent,GitHubBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GitHubBindingSpec());

    if (instance != null) {
      fluent.withAccessToken(instance.getAccessToken());
      fluent.withSubject(instance.getSubject());
      fluent.withAccessToken(instance.getAccessToken());
      fluent.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpec instance) {
    this(instance,false);
  }
  public GitHubBindingSpecBuilder(GitHubBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GitHubBindingSpec());

    if (instance != null) {
      this.withAccessToken(instance.getAccessToken());
      this.withSubject(instance.getSubject());
      this.withAccessToken(instance.getAccessToken());
      this.withSubject(instance.getSubject());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubBindingSpec build() {
    GitHubBindingSpec buildable = new GitHubBindingSpec(fluent.buildAccessToken(),fluent.buildSubject());
    return buildable;
  }
  
}