package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaChannelSpecBuilder extends KafkaChannelSpecFluent<KafkaChannelSpecBuilder> implements VisitableBuilder<KafkaChannelSpec,KafkaChannelSpecBuilder>{
  public KafkaChannelSpecBuilder() {
    this(false);
  }
  public KafkaChannelSpecBuilder(Boolean validationEnabled) {
    this(new KafkaChannelSpec(), validationEnabled);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaChannelSpec(), validationEnabled);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,KafkaChannelSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,KafkaChannelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaChannelSpec());

    if (instance != null) {
      fluent.withDelivery(instance.getDelivery());
      fluent.withNumPartitions(instance.getNumPartitions());
      fluent.withReplicationFactor(instance.getReplicationFactor());
      fluent.withRetentionDuration(instance.getRetentionDuration());
      fluent.withSubscribers(instance.getSubscribers());
      fluent.withDelivery(instance.getDelivery());
      fluent.withNumPartitions(instance.getNumPartitions());
      fluent.withReplicationFactor(instance.getReplicationFactor());
      fluent.withRetentionDuration(instance.getRetentionDuration());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpec instance) {
    this(instance,false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaChannelSpec());

    if (instance != null) {
      this.withDelivery(instance.getDelivery());
      this.withNumPartitions(instance.getNumPartitions());
      this.withReplicationFactor(instance.getReplicationFactor());
      this.withRetentionDuration(instance.getRetentionDuration());
      this.withSubscribers(instance.getSubscribers());
      this.withDelivery(instance.getDelivery());
      this.withNumPartitions(instance.getNumPartitions());
      this.withReplicationFactor(instance.getReplicationFactor());
      this.withRetentionDuration(instance.getRetentionDuration());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaChannelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaChannelSpec build() {
    KafkaChannelSpec buildable = new KafkaChannelSpec(fluent.buildDelivery(),fluent.getNumPartitions(),fluent.getReplicationFactor(),fluent.getRetentionDuration(),fluent.buildSubscribers());
    return buildable;
  }
  
}