package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaChannelStatusBuilder extends KafkaChannelStatusFluent<KafkaChannelStatusBuilder> implements VisitableBuilder<KafkaChannelStatus,KafkaChannelStatusBuilder>{
  public KafkaChannelStatusBuilder() {
    this(false);
  }
  public KafkaChannelStatusBuilder(Boolean validationEnabled) {
    this(new KafkaChannelStatus(), validationEnabled);
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaChannelStatus(), validationEnabled);
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,KafkaChannelStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatusFluent<?> fluent,KafkaChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaChannelStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatus instance) {
    this(instance,false);
  }
  public KafkaChannelStatusBuilder(KafkaChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaChannelStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscribers(instance.getSubscribers());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaChannelStatus build() {
    KafkaChannelStatus buildable = new KafkaChannelStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration(),fluent.buildSubscribers());
    return buildable;
  }
  
}