package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceSpecBuilder extends KafkaSourceSpecFluent<KafkaSourceSpecBuilder> implements VisitableBuilder<KafkaSourceSpec,KafkaSourceSpecBuilder>{
  public KafkaSourceSpecBuilder() {
    this(false);
  }
  public KafkaSourceSpecBuilder(Boolean validationEnabled) {
    this(new KafkaSourceSpec(), validationEnabled);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSourceSpec(), validationEnabled);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaSourceSpec());

    if (instance != null) {
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withConsumerGroup(instance.getConsumerGroup());
      fluent.withConsumers(instance.getConsumers());
      fluent.withDelivery(instance.getDelivery());
      fluent.withInitialOffset(instance.getInitialOffset());
      fluent.withNet(instance.getNet());
      fluent.withSink(instance.getSink());
      fluent.withTopics(instance.getTopics());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withCeOverrides(instance.getCeOverrides());
      fluent.withConsumerGroup(instance.getConsumerGroup());
      fluent.withConsumers(instance.getConsumers());
      fluent.withDelivery(instance.getDelivery());
      fluent.withInitialOffset(instance.getInitialOffset());
      fluent.withNet(instance.getNet());
      fluent.withSink(instance.getSink());
      fluent.withTopics(instance.getTopics());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpec instance) {
    this(instance,false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaSourceSpec());

    if (instance != null) {
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withCeOverrides(instance.getCeOverrides());
      this.withConsumerGroup(instance.getConsumerGroup());
      this.withConsumers(instance.getConsumers());
      this.withDelivery(instance.getDelivery());
      this.withInitialOffset(instance.getInitialOffset());
      this.withNet(instance.getNet());
      this.withSink(instance.getSink());
      this.withTopics(instance.getTopics());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withCeOverrides(instance.getCeOverrides());
      this.withConsumerGroup(instance.getConsumerGroup());
      this.withConsumers(instance.getConsumers());
      this.withDelivery(instance.getDelivery());
      this.withInitialOffset(instance.getInitialOffset());
      this.withNet(instance.getNet());
      this.withSink(instance.getSink());
      this.withTopics(instance.getTopics());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSourceSpec build() {
    KafkaSourceSpec buildable = new KafkaSourceSpec(fluent.getBootstrapServers(),fluent.buildCeOverrides(),fluent.getConsumerGroup(),fluent.getConsumers(),fluent.buildDelivery(),fluent.getInitialOffset(),fluent.buildNet(),fluent.buildSink(),fluent.getTopics());
    return buildable;
  }
  
}