package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceStatusBuilder extends KafkaSourceStatusFluent<KafkaSourceStatusBuilder> implements VisitableBuilder<KafkaSourceStatus,KafkaSourceStatusBuilder>{
  public KafkaSourceStatusBuilder() {
    this(false);
  }
  public KafkaSourceStatusBuilder(Boolean validationEnabled) {
    this(new KafkaSourceStatus(), validationEnabled);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSourceStatus(), validationEnabled);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,KafkaSourceStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatusFluent<?> fluent,KafkaSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaSourceStatus());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withClaims(instance.getClaims());
      fluent.withConditions(instance.getConditions());
      fluent.withConsumers(instance.getConsumers());
      fluent.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPlacements(instance.getPlacements());
      fluent.withSelector(instance.getSelector());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCeAttributes(instance.getCeAttributes());
      fluent.withClaims(instance.getClaims());
      fluent.withConditions(instance.getConditions());
      fluent.withConsumers(instance.getConsumers());
      fluent.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPlacements(instance.getPlacements());
      fluent.withSelector(instance.getSelector());
      fluent.withSinkCACerts(instance.getSinkCACerts());
      fluent.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatus instance) {
    this(instance,false);
  }
  public KafkaSourceStatusBuilder(KafkaSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaSourceStatus());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withClaims(instance.getClaims());
      this.withConditions(instance.getConditions());
      this.withConsumers(instance.getConsumers());
      this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPlacements(instance.getPlacements());
      this.withSelector(instance.getSelector());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
      this.withAnnotations(instance.getAnnotations());
      this.withCeAttributes(instance.getCeAttributes());
      this.withClaims(instance.getClaims());
      this.withConditions(instance.getConditions());
      this.withConsumers(instance.getConsumers());
      this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPlacements(instance.getPlacements());
      this.withSelector(instance.getSelector());
      this.withSinkCACerts(instance.getSinkCACerts());
      this.withSinkUri(instance.getSinkUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSourceStatus build() {
    KafkaSourceStatus buildable = new KafkaSourceStatus(fluent.getAnnotations(),fluent.buildCeAttributes(),fluent.getClaims(),fluent.buildConditions(),fluent.getConsumers(),fluent.getMaxAllowedVReplicas(),fluent.getObservedGeneration(),fluent.buildPlacements(),fluent.getSelector(),fluent.getSinkCACerts(),fluent.getSinkUri());
    return buildable;
  }
  
}