package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerStatusBuilder extends BrokerStatusFluent<BrokerStatusBuilder> implements VisitableBuilder<BrokerStatus,BrokerStatusBuilder>{
  public BrokerStatusBuilder() {
    this(false);
  }
  public BrokerStatusBuilder(Boolean validationEnabled) {
    this(new BrokerStatus(), validationEnabled);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerStatus(), validationEnabled);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance) {
    this(fluent, instance, false);
  }
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BrokerStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAddress(instance.getAddress());
      fluent.withAddresses(instance.getAddresses());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerStatusBuilder(BrokerStatus instance) {
    this(instance,false);
  }
  public BrokerStatusBuilder(BrokerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BrokerStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAddress(instance.getAddress());
      this.withAddresses(instance.getAddresses());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerStatus build() {
    BrokerStatus buildable = new BrokerStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration());
    return buildable;
  }
  
}