package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerBuilder extends TriggerFluent<TriggerBuilder> implements VisitableBuilder<Trigger,TriggerBuilder>{
  public TriggerBuilder() {
    this(false);
  }
  public TriggerBuilder(Boolean validationEnabled) {
    this(new Trigger(), validationEnabled);
  }
  public TriggerBuilder(TriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerBuilder(TriggerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Trigger(), validationEnabled);
  }
  public TriggerBuilder(TriggerFluent<?> fluent,Trigger instance) {
    this(fluent, instance, false);
  }
  public TriggerBuilder(TriggerFluent<?> fluent,Trigger instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Trigger());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerBuilder(Trigger instance) {
    this(instance,false);
  }
  public TriggerBuilder(Trigger instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Trigger());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerFluent<?> fluent;
  Boolean validationEnabled;
  public Trigger build() {
    Trigger buildable = new Trigger(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}