package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerFilterBuilder extends TriggerFilterFluent<TriggerFilterBuilder> implements VisitableBuilder<TriggerFilter,TriggerFilterBuilder>{
  public TriggerFilterBuilder() {
    this(false);
  }
  public TriggerFilterBuilder(Boolean validationEnabled) {
    this(new TriggerFilter(), validationEnabled);
  }
  public TriggerFilterBuilder(TriggerFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerFilter(), validationEnabled);
  }
  public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,TriggerFilter instance) {
    this(fluent, instance, false);
  }
  public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,TriggerFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TriggerFilter());

    if (instance != null) {
      fluent.withAttributes(instance.getAttributes());
      fluent.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerFilterBuilder(TriggerFilter instance) {
    this(instance,false);
  }
  public TriggerFilterBuilder(TriggerFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TriggerFilter());

    if (instance != null) {
      this.withAttributes(instance.getAttributes());
      this.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerFilterFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerFilter build() {
    TriggerFilter buildable = new TriggerFilter(fluent.getAttributes());
    return buildable;
  }
  
}