package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParallelBranchStatusBuilder extends ParallelBranchStatusFluent<ParallelBranchStatusBuilder> implements VisitableBuilder<ParallelBranchStatus,ParallelBranchStatusBuilder>{
  public ParallelBranchStatusBuilder() {
    this(false);
  }
  public ParallelBranchStatusBuilder(Boolean validationEnabled) {
    this(new ParallelBranchStatus(), validationEnabled);
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParallelBranchStatus(), validationEnabled);
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,ParallelBranchStatus instance) {
    this(fluent, instance, false);
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,ParallelBranchStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ParallelBranchStatus());

    if (instance != null) {
      fluent.withFilterChannelStatus(instance.getFilterChannelStatus());
      fluent.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus());
      fluent.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus());
      fluent.withFilterChannelStatus(instance.getFilterChannelStatus());
      fluent.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus());
      fluent.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatus instance) {
    this(instance,false);
  }
  public ParallelBranchStatusBuilder(ParallelBranchStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ParallelBranchStatus());

    if (instance != null) {
      this.withFilterChannelStatus(instance.getFilterChannelStatus());
      this.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus());
      this.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus());
      this.withFilterChannelStatus(instance.getFilterChannelStatus());
      this.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus());
      this.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParallelBranchStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ParallelBranchStatus build() {
    ParallelBranchStatus buildable = new ParallelBranchStatus(fluent.buildFilterChannelStatus(),fluent.buildFilterSubscriptionStatus(),fluent.buildSubscriberSubscriptionStatus());
    return buildable;
  }
  
}