package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceChannelStatusBuilder extends SequenceChannelStatusFluent<SequenceChannelStatusBuilder> implements VisitableBuilder<SequenceChannelStatus,SequenceChannelStatusBuilder>{
  public SequenceChannelStatusBuilder() {
    this(false);
  }
  public SequenceChannelStatusBuilder(Boolean validationEnabled) {
    this(new SequenceChannelStatus(), validationEnabled);
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceChannelStatus(), validationEnabled);
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,SequenceChannelStatus instance) {
    this(fluent, instance, false);
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,SequenceChannelStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SequenceChannelStatus());

    if (instance != null) {
      fluent.withChannel(instance.getChannel());
      fluent.withReady(instance.getReady());
      fluent.withChannel(instance.getChannel());
      fluent.withReady(instance.getReady());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatus instance) {
    this(instance,false);
  }
  public SequenceChannelStatusBuilder(SequenceChannelStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SequenceChannelStatus());

    if (instance != null) {
      this.withChannel(instance.getChannel());
      this.withReady(instance.getReady());
      this.withChannel(instance.getChannel());
      this.withReady(instance.getReady());
    }
    this.validationEnabled = validationEnabled; 
  }
  SequenceChannelStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceChannelStatus build() {
    SequenceChannelStatus buildable = new SequenceChannelStatus(fluent.buildChannel(),fluent.buildReady());
    return buildable;
  }
  
}