package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceListBuilder extends SequenceListFluent<SequenceListBuilder> implements VisitableBuilder<SequenceList,SequenceListBuilder>{
  public SequenceListBuilder() {
    this(false);
  }
  public SequenceListBuilder(Boolean validationEnabled) {
    this(new SequenceList(), validationEnabled);
  }
  public SequenceListBuilder(SequenceListFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceListBuilder(SequenceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceList(), validationEnabled);
  }
  public SequenceListBuilder(SequenceListFluent<?> fluent,SequenceList instance) {
    this(fluent, instance, false);
  }
  public SequenceListBuilder(SequenceListFluent<?> fluent,SequenceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SequenceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SequenceListBuilder(SequenceList instance) {
    this(instance,false);
  }
  public SequenceListBuilder(SequenceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SequenceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  SequenceListFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceList build() {
    SequenceList buildable = new SequenceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}