package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceStatusBuilder extends SequenceStatusFluent<SequenceStatusBuilder> implements VisitableBuilder<SequenceStatus,SequenceStatusBuilder>{
  public SequenceStatusBuilder() {
    this(false);
  }
  public SequenceStatusBuilder(Boolean validationEnabled) {
    this(new SequenceStatus(), validationEnabled);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceStatus(), validationEnabled);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance) {
    this(fluent, instance, false);
  }
  public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SequenceStatus());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChannelStatuses(instance.getChannelStatuses());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses());
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withChannelStatuses(instance.getChannelStatuses());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SequenceStatusBuilder(SequenceStatus instance) {
    this(instance,false);
  }
  public SequenceStatusBuilder(SequenceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SequenceStatus());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withChannelStatuses(instance.getChannelStatuses());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscriptionStatuses(instance.getSubscriptionStatuses());
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withChannelStatuses(instance.getChannelStatuses());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withSubscriptionStatuses(instance.getSubscriptionStatuses());
    }
    this.validationEnabled = validationEnabled; 
  }
  SequenceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceStatus build() {
    SequenceStatus buildable = new SequenceStatus(fluent.buildAddress(),fluent.getAnnotations(),fluent.buildChannelStatuses(),fluent.buildConditions(),fluent.getObservedGeneration(),fluent.buildSubscriptionStatuses());
    return buildable;
  }
  
}