package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SequenceSubscriptionStatusBuilder extends SequenceSubscriptionStatusFluent<SequenceSubscriptionStatusBuilder> implements VisitableBuilder<SequenceSubscriptionStatus,SequenceSubscriptionStatusBuilder>{
  public SequenceSubscriptionStatusBuilder() {
    this(false);
  }
  public SequenceSubscriptionStatusBuilder(Boolean validationEnabled) {
    this(new SequenceSubscriptionStatus(), validationEnabled);
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SequenceSubscriptionStatus(), validationEnabled);
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,SequenceSubscriptionStatus instance) {
    this(fluent, instance, false);
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,SequenceSubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SequenceSubscriptionStatus());

    if (instance != null) {
      fluent.withReady(instance.getReady());
      fluent.withSubscription(instance.getSubscription());
      fluent.withReady(instance.getReady());
      fluent.withSubscription(instance.getSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatus instance) {
    this(instance,false);
  }
  public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SequenceSubscriptionStatus());

    if (instance != null) {
      this.withReady(instance.getReady());
      this.withSubscription(instance.getSubscription());
      this.withReady(instance.getReady());
      this.withSubscription(instance.getSubscription());
    }
    this.validationEnabled = validationEnabled; 
  }
  SequenceSubscriptionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SequenceSubscriptionStatus build() {
    SequenceSubscriptionStatus buildable = new SequenceSubscriptionStatus(fluent.buildReady(),fluent.buildSubscription());
    return buildable;
  }
  
}