package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricSpecBuilder extends MetricSpecFluent<MetricSpecBuilder> implements VisitableBuilder<MetricSpec,MetricSpecBuilder>{
  public MetricSpecBuilder() {
    this(false);
  }
  public MetricSpecBuilder(Boolean validationEnabled) {
    this(new MetricSpec(), validationEnabled);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricSpec(), validationEnabled);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,MetricSpec instance) {
    this(fluent, instance, false);
  }
  public MetricSpecBuilder(MetricSpecFluent<?> fluent,MetricSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MetricSpec());

    if (instance != null) {
      fluent.withPanicWindow(instance.getPanicWindow());
      fluent.withScrapeTarget(instance.getScrapeTarget());
      fluent.withStableWindow(instance.getStableWindow());
      fluent.withPanicWindow(instance.getPanicWindow());
      fluent.withScrapeTarget(instance.getScrapeTarget());
      fluent.withStableWindow(instance.getStableWindow());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricSpecBuilder(MetricSpec instance) {
    this(instance,false);
  }
  public MetricSpecBuilder(MetricSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MetricSpec());

    if (instance != null) {
      this.withPanicWindow(instance.getPanicWindow());
      this.withScrapeTarget(instance.getScrapeTarget());
      this.withStableWindow(instance.getStableWindow());
      this.withPanicWindow(instance.getPanicWindow());
      this.withScrapeTarget(instance.getScrapeTarget());
      this.withStableWindow(instance.getStableWindow());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MetricSpec build() {
    MetricSpec buildable = new MetricSpec(fluent.getPanicWindow(),fluent.getScrapeTarget(),fluent.getStableWindow());
    return buildable;
  }
  
}